<?php

require_once __DIR__.'/config.php';

/**
 * Инициализация клоакинга
 */
function cloakInit() {
  global $cloakCfg;

  // Проверяем на бота Яндекс
  if (isset($cloakCfg['check']['yandexBot']) && isset($cloakCfg['yandexBots'])) {
    if (cloakIsSearchBot($cloakCfg['yandexBots'])) {
      include $cloakCfg['check']['yandexBot'];
      return;
    }
  }

  // Проверяем на бота Google
  if (isset($cloakCfg['check']['googleBot']) && isset($cloakCfg['googleBots'])) {
    if (cloakIsSearchBot($cloakCfg['googleBots'])) {
      include $cloakCfg['check']['googleBot'];
      return;
    }
  }

  // Для перехода из поиска
  if (cloakIsSearch()) {
    $ip = cloakGetIp();
    $geo = cloakGetGeo($ip);

    // Проверяем на страну
    if (isset($cloakCfg['check']['country'])) {
      if ($page = cloakIsGeo($cloakCfg['check']['country'], $geo['country'])) {
        include $page;
        return;
      }
    }

    // Проверяем на регион
    if (isset($cloakCfg['check']['region'])) {
      if ($page = cloakIsGeo($cloakCfg['check']['region'], $geo['region'])) {
        echo 'z1';
        include $page;
        return;
      }
    }

    // Проверяем на город
    if (isset($cloakCfg['check']['city'])) {
      if ($page = cloakIsGeo($cloakCfg['check']['city'], $geo['city'])) {
        include $page;
        return;
      }
    }
  }

  if (isset($cloakCfg['default'])) {
    include $cloakCfg['default'];
  }
}

/**
 * Получение IP
 * @return string
 */
function cloakGetIp() {
  if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
    $ip = $_SERVER['HTTP_CLIENT_IP'];
  } else if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
    $ip = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
    $ip = $ip[0];
  } else $ip = $_SERVER['REMOTE_ADDR'];

  return trim($ip);
}

/**
 * Получение гео по IP адресу
 * @param string $ip IP адрес
 * @return array
 */
function cloakGetGeo($ip) {
  $dir = __DIR__.'/sxgeo';
  require_once "$dir/SxGeo.php";

  $SxGeo = new SxGeo("$dir/SxGeoCity.dat", SXGEO_BATCH | SXGEO_MEMORY);
  $geo = $SxGeo->getCityFull($ip);
  unset($SxGeo);

  return [
    'country' => $geo['country']['iso'],
    'region' => $geo['region']['name_ru'],
    'city' => $geo['city']['name_ru'],
  ];
}

/**
 * Проверка на бота
 * @param array $bots массив ботов поисковой системы
 * @return boolean
 */
function cloakIsSearchBot($bots) {
  if (!empty($bots) && !empty($_SERVER['HTTP_USER_AGENT'])) {
    foreach ($bots as $bot) {
      if (stripos($_SERVER['HTTP_USER_AGENT'], $bot) !== false) {
        return true;
      }
    }
  }
  return false;
}

/**
 * Проверка на гео
 * @param array $geo массив гео
 * @param string $value проверяемое гео
 * @return boolean|string
 */
function cloakIsGeo($geo, $value) {
  if (!empty($geo) && !empty($value)) {
    foreach ($geo as $key => $page) {
      if ($key == $value) {
        return $page;
      }
    }
  }
  return false;
}

/**
 * Проверка на ПС в referer
 * @return boolean
 */
function cloakIsSearch() {
  if (isset($_SERVER['HTTP_REFERER'])) {
    $referer = strtolower($_SERVER['HTTP_REFERER']);
    if (strpos($referer, 'google') !== false || strpos($referer, 'yandex') !== false) {
      return true;
    }
  }
  return false;
}
